'
' This program records a voice file TEMP.VOC
'

' $INCLUDE: 'SBC.BI'
' $INCLUDE: 'SBCSYS.BI'
' $INCLUDE: 'SBCVOICE.BI'

DECLARE FUNCTION LDVFILE% (filename$, segment%, offset%)
DECLARE SUB RECFILE(filename$,buffer%())
DECLARE FUNCTION RECORD%(buffer%(),bufsize&)
DECLARE SUB SAVEVOC(filename$,buffer%())


REM $DYNAMIC
CLEAR

' Following statements free memory for the loadable drivers.
' You must free sufficient memory for the loadable drivers.
' The free memory must be larger than the driver file size.

' Free 8K memory for the CT-VOICE.DRV at the moment
DUMMY = SETMEM(-8192)

' Allocate 100K buffer for voice data file
DIM buffer%(1 TO 100, 1 TO 512)

CLS
PRINT "SBK Voice Recording (memory version) Example"

IF (SBGETENV% = 0) THEN
    IF SBCHKCRD% THEN
        IF SBTSTINT% THEN
            IF SBTSTDMA% >= 0 THEN

                ' Load CT-VOICE.DRV
                DRVADDX% = LOADDRV% ("CT-VOICE.DRV")

                ' If driver loaded successfully
                IF (DRVADDX% <> 0) THEN

                    ' Set driver address
                    CTVADDX (DRVADDX%)

                    ' Initialize driver
                    IF (SVMINIT% = 0) THEN
                        CALL SVMSPKER(INT(0))

                        ' Record a voice file
                        CALL RECFILE("TEMP.VOC",buffer%())

                        ' Terminate driver before exit
                        CALL SVMEXIT
                    END IF

                    ' Release memory allocated for CT-VOICE
                    CALL FREEMEM(DRVADDX%)
                END IF
            ELSE
                PRINT "Error on DMA channel."
            ENDIF
        ELSE
            PRINT "Error on interrupt."
        ENDIF
    ELSE
        PRINT "Sound Blaster Card not found or wrong I/O setting"
    ENDIF
ELSE
    PRINT "BLASTER environment variable not set or incomplete or invalid."
ENDIF

' Return memory to BASIC
DUMMY = SETMEM(8192)

END


' ------------------------------------------------------------------------ '

FUNCTION LOADDRV% (szDrvName$)

    DIM szDrvFile$, Handle%, dwFileLen&, wDrvSeg%


    LOADDRV% = 0

    ' search SOUND environment for driver
    szDrvFile$ = ENVIRON$("SOUND")

    IF (szDrvFile$ <> "") THEN
        szDrvFile$ = szDrvFile$ + "\DRV\" + szDrvName$

        IF (FINDFILE%(szDrvFile$) = 0) THEN
            szDrvFile$ = ""
        ENDIF
    ENDIF

    ' search the current directory for driver
    IF (szDrvFile$ = "") THEN
        szDrvFile$ = szDrvName$
    ENDIF

    IF (FINDFILE%(szDrvFile$) <> 0) THEN
        Handle% = DOSOPEN%(szDrvFile$)

        IF (Handle% <> 0) THEN
            dwFileLen& = FILESIZE(Handle%)

            wDrvSeg% = ALLOCMEM(INT((dwFileLen& + 15) / 16))

            IF (wDrvSeg% <> 0) THEN
                IF DOSREAD%(Handle%, INT(0), wDrvSeg%, dwFileLen&) THEN
                    LOADDRV% = wDrvSeg%
                ENDIF
            ENDIF

            DOSCLOSE(Handle%)
        ELSE
            PRINT "Error in opening " + szDrvFile$
        ENDIF
    ELSE
        PRINT "Driver file " + szDrvName$ + " does not exist ..."
    ENDIF

END FUNCTION


' ------------------------------------------------------------------------ '

REM $STATIC
SUB RECFILE(filename$,buffer%())

' This function records a voice buffer and saves it into file

     DIM   bufsize AS LONG

     ' Set the buffer size to 100K
     bufsize = 100000&

     IF (RECORD%(buffer%(),bufsize) <> 0) THEN
	  CALL SAVEVOC(filename$,buffer%())
     ENDIF

END SUB


' ------------------------------------------------------------------------ '


FUNCTION RECORD%(buffer%(),bufsize&)

' This function records the voice, until buffer full.
' Keyboard input is checked for terminating the recording before the buffer
' is full.

     DIM userkey AS INTEGER, voice AS INTEGER

     CALL SVMSPKER(INT(0))
     RECORD% = 0

     IF (SVMINPUT%(buffer%(1,1),bufsize&,INT(8000)) = 0) THEN

	  RECORD% = 1

	  WHILE CTVOICE% <> 0

	       c$ = INKEY$

	       IF c$ <> "" THEN

		    IF c$=chr$(27) THEN
			 CALL SVMSTOP
		    ENDIF

	       END IF

	  WEND

     END IF

END FUNCTION


' ------------------------------------------------------------------------ '


SUB SAVEVOC(filename$,buffer%())

' This function save the buffer into a Creative Voice file format

     DIM header AS VOCHDR, handle AS INTEGER, bufsize AS LONG

     ' Setup the voice file format
     header.id = "Creative Voice File" + CHR$(26)
     header.offset = 26
     header.version = &H10A
     header.checkcode = &H1129

     ' Create a file
     handle = DOSCREATE%(filename$)

     IF (handle <> 0) THEN

	  ' Write the file header
	  IF (DOSWRITE%(handle,VARPTR(header.id),VARSEG(header.id),26) <> 0) THEN

	       ' Get the voice block length from buffer
	       DEF SEG = VARSEG(buffer%(1,1))
		    bufsize = PEEK(VARPTR(buffer%(1,1)) + 1)
	       DEF SEG

	       bufsize = bufsize + 256& * buffer%(2,1)

	       ' Add 5 bytes for the block header and terminating block
	       bufsize = bufsize + 5

	       ' Write the buffer
	       IF (DOSWRITE%(handle,VARPTR(buffer%(1,1)),VARSEG(buffer%(1,1)),bufsize) = 0) THEN
		    PRINT "Write file error."
	       ENDIF

	  ENDIF

	  CALL DOSCLOSE(handle)
     ELSE
	  PRINT "Creating file error.\n"
     ENDIF

END SUB
